require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require_relative '../../module/DriverUtility'
require_relative '../../pages/landing_notifications'
require_relative '../../pages/appointments/request_appointment_detail'
require 'watir-scroll'

describe '[Story VAR-8701 :VAR - CC Specialty/Find a PCP - Update to Appointment and Provider Preferences wizard pages]
          [Story VAR-11042: VAR - CC Find PCP - Veteran Cancelling a Find PCP request]', :varList_MockService => false do
  include DriverUtility
  include DateUtility
  include OracleUtility
  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @request_appointment_detail = RequestAppointmentDetail.new(@driver)
    @@sixDaysLater= getDateNthDaysFromNow(6,"%m/%d/%Y")
  end

  after(:all) do
    @cc_po.loginLogout.logout
  end

  context "AC#11218|TC#11219:VAR - CC Specialty/Find a PCP - Update to Appointment and Provider Preferences wizard pages" do

    it "Login and select PCP care type and navigate to Provider Preference wizard" do
      @cc_po.common.loginEndsOnHome(pw_redacted)
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.eligibility_yes_element.click
      @cc_po.communityCare.continue_btn
      @cc_po.communityCare.facility_radio_btn_elements[1].click
      @cc_po.communityCare.care_type = "Find a Provider (primary care)"
      @cc_po.communityCare.con_yes_element.click
      @cc_po.communityCare.clickContinueButton
    end

    it "Verify the Provider Preference Wizard contents" do
      actual_content = @cc_po.communityCare.provider_pref_element.text.split("\n")
      expected_content = [\
                                "* required field",
                                "Step 5: Provider",
                                "Preferences",
                                "Please indicate the attributes you are looking for in a provider.",
                                "Preferred Location",
                                "* City",
                                "* State",
                                " Select",
                                "AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC","FL","GA","GU","HI","ID","IL","IN","IA","KS","KY","LA","ME","MD","MA","MI","MN","MS","MO","MT","NE","NV","NH","NJ","NM","NY","NC","ND","MP","OH","OK","OR","PA","PR","RI","SC","SD","TN","TX","UT","VI","VT","VA","WA","WV","WI","WY",
                                "ZIP Code",
                                " * How many miles away from this location are you willing to travel?",
                                "10 25 50 100 or more",
                                "* Preferred Language Spoken",
                                " Select",
                                "English",
                                "Chinese",
                                "French",
                                "German",
                                "Italian",
                                "Korean",
                                "Portuguese",
                                "Russian",
                                "Spanish",
                                "Tagalog (Filipino)",
                                "Vietnamese",
                                "Other",
                                "* Office Hours (check all that apply)",
                                "Weekdays",
                                "Evenings",
                                " Weekends",
                                "Preferred Providers",
                                "You may indicate up to three providers. Please visit our Veteran Choice Locator to find a provider on our approved list.",
                                "Provider Choice #1",
                                "First Name",
                                "Last Name",
                                "Practice Name",
                                "Street Address",
                                "City",
                                "State","Select","AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "MP", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VI", "VT", "VA", "WA", "WV", "WI", "WY",
                                "ZIP Code",
                                "+ Add Provider",
                                "Other Provider Preferences",
                                "(250 char limit)",
                                "250 characters remaining",
                                "Previous",
                                "Continue",
                                "Exit"

      ]
      comp_text(expected_content, actual_content)
    end

    it "Fill out all the required fields and verify 'Continue' button is enabled" do
      @cc_po.communityCare.provider_city = "Dulles"
      @cc_po.communityCare.provider_state = "VA"
      @cc_po.communityCare.provider_zip = "20166"
      @cc_po.communityCare.preferred_miles_elements[0].click
      @cc_po.communityCare.preferred_lang = "Chinese"
      @cc_po.communityCare.office_hrs_elements[1].click
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq true
    end

    it "Go back, perform distance eligibility check and verify address prepopulated on Preffred Provider wizard" do
      @cc_po.communityCare.previous_btn
      @cc_po.communityCare.previous_btn
      @cc_po.communityCare.eligibility_no_element.click
      @cc_po.communityCare.travel_no_element.click
      @cc_po.communityCare.unusual_no_element.click
      @cc_po.communityCare.address = '290 Sharon Rd'
      @cc_po.communityCare.address_element.fire_event('onblur')
      @cc_po.communityCare.city = 'Lakeville'
      @cc_po.communityCare.city_element.fire_event('onblur')
      @cc_po.communityCare.state = 'CT'
      @cc_po.communityCare.state_element.fire_event('onblur')
      @cc_po.communityCare.zip_code_1st_question = '06039'
      @cc_po.communityCare.zip_code_1st_question_element.fire_event('onblur')
      @cc_po.communityCare.find_nearest_facility_element.click
      @cc_po.common.waitWhileSpinnerPresent
      @cc_po.communityCare.clickContinueButton
      @cc_po.communityCare.clickContinueButton
      expect(@cc_po.communityCare.provider_city).to eq("Dulles")
      expect(@cc_po.communityCare.provider_state).to eq('VA')
      expect(@cc_po.communityCare.provider_zip).to eq("20166")
      @cc_po.communityCare.previous_btn_element.scroll.to :bottom
      @cc_po.communityCare.previous_btn
    end

    it "Go back and change care type and verify Step 6 shows provider preference wizard" do
      @cc_po.communityCare.care_type = "Audiology (hearing aid support)"
      @cc_po.communityCare.con_yes_element.click
      @cc_po.communityCare.clickContinueButton
      @cc_po.communityCare.choice1_date = @@sixDaysLater
      @cc_po.communityCare.radio_am_pm_elements[1].click
      @cc_po.communityCare.previous_btn_element.scroll.to :bottom
      @cc_po.communityCare.clickContinueButton
      actual_content = @cc_po.communityCare.provider_pref_element.text.split("\n")
      expected_content = [\
                                "* required field",
                                "Step 6: Provider",
                                "Preferences",
                                "Please indicate the attributes you are looking for in a provider.",
                                "Preferred Location",
                                "* City",
                                "* State",
                                " Select",
                                "AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC","FL","GA","GU","HI","ID","IL","IN","IA","KS","KY","LA","ME","MD","MA","MI","MN","MS","MO","MT","NE","NV","NH","NJ","NM","NY","NC","ND","MP","OH","OK","OR","PA","PR","RI","SC","SD","TN","TX","UT","VI","VT","VA","WA","WV","WI","WY",
                                "ZIP Code",
                                " * How many miles away from this location are you willing to travel?",
                                "10 25 50 100 or more",
                                "* Preferred Language Spoken",
                                " Select",
                                "English",
                                "Chinese",
                                "French",
                                "German",
                                "Italian",
                                "Korean",
                                "Portuguese",
                                "Russian",
                                "Spanish",
                                "Tagalog (Filipino)",
                                "Vietnamese",
                                "Other",
                                "* Office Hours (check all that apply)",
                                "Weekdays",
                                "Evenings",
                                " Weekends",
                                "Preferred Providers",
                                "You may indicate up to three providers. Please visit our Veteran Choice Locator to find a provider on our approved list.",
                                "Provider Choice #1",
                                "First Name",
                                "Last Name",
                                "Practice Name",
                                "Street Address",
                                "City",
                                "State","Select","AL","AK","AR","AS","AZ","CA","CO","CT","DE","DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MD", "MA", "MI", "MN", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "MP", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VI", "VT", "VA", "WA", "WV", "WI", "WY",
                                "ZIP Code",
                                "+ Add Provider",
                                "Other Provider Preferences",
                                "(250 char limit)",
                                "250 characters remaining",
                                "Previous",
                                "Continue",
                                "Exit"
      ]
      comp_text(expected_content, actual_content)
    end

  end

    def comp_text(expected_content, actual_content)
      expected_content.each_with_index do |expectedScreenRow, i|
        expect(actual_content[i].to_s.strip).to eq(expectedScreenRow.to_s.strip)
      end
      expect(expected_content.size).to eq(actual_content.size)
    end

end
